/*
 * Copyright (c) 1998, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.jdi.event;

import com.sun.jdi.Mirror;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;

/**
 * Manager of incoming debugger events for a target VM.
 * Events are always grouped in {@link EventSet}s.
 * EventSets generated by the debugger back end can be read
 * here. There is one instance of EventQueue assigned to a particular
 * {@link VirtualMachine VirtualMachine}.
 * <P>
 * Some events cause the suspension of the target VM - event requests
 * ({@link com.sun.jdi.request}) with a
 * {@link EventRequest#suspendPolicy() suspend policy}
 * of {@link EventRequest#SUSPEND_ALL SUSPEND_ALL}
 * or {@link EventRequest#SUSPEND_EVENT_THREAD
 * SUSPEND_EVENT_THREAD} and sometimes {@link VMStartEvent}.
 * If these suspensions are not resumed the target VM will hang.
 * Thus, it is always good policy to
 * {@link #remove() remove()} every EventSet from the event queue until
 * an EventSet containing a {@link VMDisconnectEvent} is read.
 * Unless {@link VirtualMachine#resume() resume} is
 * being handled in another way, each EventSet should invoke
 * {@link EventSet#resume()}.
 *
 * @see EventSet
 * @see VirtualMachine
 *
 * @author Robert Field
 * @since  1.3
 */
public interface EventQueue extends Mirror {

    /**
     * Waits forever for the next available event.
     *
     * @return the next {@link EventSet}.
     * @throws InterruptedException if any thread has interrupted this thread.
     * @throws VMDisconnectedException if the connection
     * to the target VM is no longer available. Note this will always
     * be preceded by a {@link VMDisconnectEvent}.
     */
    EventSet remove() throws InterruptedException;

    /**
     * Waits a specified time for the next available event.
     *
     * @param timeout Time in milliseconds to wait for the next event
     * @return the next {@link EventSet}, or null if there is a timeout.
     * @throws InterruptedException if any thread has interrupted
     * this thread.
     * @throws VMDisconnectedException if the connection
     * to the target VM is no longer available. Note this will always
     * be preceded by a {@link VMDisconnectEvent}.
     * @throws IllegalArgumentException if the timeout argument
     * contains an illegal value.
     */
    EventSet remove(long timeout) throws InterruptedException;
}
