/*
 * Copyright (c) 2010, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.nashorn.internal.runtime.linker;

import java.util.Objects;

/**
 * Represents a an adapter for invoking superclass methods on an adapter instance generated by
 * {@code JavaAdapterBytecodeGenerator}. Note that objects of this class are just wrappers around the adapter instances,
 * without any behavior. All the behavior is defined in the {@code JavaSuperAdapterLinker}.
 */
class JavaSuperAdapter {
    private final Object adapter;

    JavaSuperAdapter(final Object adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public Object getAdapter() {
        return adapter;
    }
}
