/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sr_Latn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Moskva, standardno vreme",
               "",
               "Moskva, letnje vreme",
               "",
               "Moskva vreme",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan, standardno vreme",
               "",
               "Pakistan, letnje vreme",
               "",
               "Pakistan vreme",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan, standardno vreme",
               "",
               "Magadan, letnje vreme",
               "",
               "Magadan vreme",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Srednjeevropsko standardno vreme",
               "CET",
               "Srednjeevropsko letnje vreme",
               "CEST",
               "Srednjeevropsko vreme",
               "CET",
            };
        final String[] Acre = new String[] {
               "Akre standardno vreme",
               "",
               "Akre letnje ra\u010dunanje vremena",
               "",
               "Akre vreme",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Severnoameri\u010dko isto\u010dno standardno vreme",
               "",
               "Severnoameri\u010dko isto\u010dno letnje vreme",
               "",
               "Severnoameri\u010dko isto\u010dno vreme",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Hov, standardno vreme",
               "",
               "Lord Hov, letnje vreme",
               "",
               "Lord Hov vreme",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Novi Zeland, standardno vreme",
               "",
               "Novi Zeland, letnje vreme",
               "",
               "Novi Zeland vreme",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijsko okeansko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk, standardno vreme",
               "",
               "Jakutsk, letnje vreme",
               "",
               "Jakutsk vreme",
               "",
            };
        final String[] East_Timor = new String[] {
               "Isto\u010dni timor vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Ko\u0161re vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Isto\u010dnoevropsko standardno vreme",
               "EET",
               "Isto\u010dnoevropsko letnje vreme",
               "EEST",
               "Isto\u010dnoevropsko vreme",
               "EET",
            };
        final String[] Argentina_Western = new String[] {
               "Zapadna Argentina, standardno vreme",
               "",
               "Zapadna Argentina, letnje vreme",
               "",
               "Zapadna Argentina vreme",
               "",
            };
        final String[] Ponape = new String[] {
               "Ponpej vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivija vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sen Pjer i Mikelon, standardno vreme",
               "",
               "Sen Pjer i Mikelon, letnje vreme",
               "",
               "Sen Pjer i Mikelon",
               "",
            };
        final String[] Indochina = new String[] {
               "Indokina vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburg, standardno vreme",
               "",
               "Jekaterinburg, letnje vreme",
               "",
               "Jekaterinburg vreme",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivi vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Valis i Futuna Ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Ju\u017eno-afri\u010dko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "\u0160ova vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Ostrva Lajn vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistan, standardno vreme",
               "",
               "Uzbekistan, letnje vreme",
               "",
               "Uzbekistan vreme",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Bator, standardno vreme",
               "",
               "Ulan Bator, letnje vreme",
               "",
               "Ulan Bator vreme",
               "",
            };
        final String[] America_Central = new String[] {
               "Severnoameri\u010dko centralno standardno vreme",
               "",
               "Severnoameri\u010dko centralno letnje vreme",
               "",
               "Severnoameri\u010dko centralno vreme",
               "",
            };
        final String[] Niue = new String[] {
               "Niue vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Vejk ostrvo vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Folklandska Ostrva, standardno vreme",
               "",
               "Folklandska Ostrva, letnje vreme",
               "",
               "Folklandska Ostrva vreme",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Apia = new String[] {
               "Apija, standardno vreme",
               "",
               "Apija, letnje vreme",
               "",
               "Apija vreme",
               "",
            };
        final String[] Nauru = new String[] {
               "Nauru vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Zapadno-kazahstansko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Bo\u017ei\u0107no ostrvo vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "Reinion vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Kokos (Keling) Ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "\u010catam, standardno vreme",
               "",
               "\u010catam, letnje vreme",
               "",
               "\u010catam vreme",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina, standardno vreme",
               "",
               "Argentina, letnje vreme",
               "",
               "Argentina vreme",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambije vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venecuela vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Feniks ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Zelenortska Ostrva, standardno vreme",
               "",
               "Zelenortska Ostrva, letnje vreme",
               "",
               "Zelenortska Ostrva vreme",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Ostrvo vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa, standardno vreme",
               "",
               "Samoa, letnje vreme",
               "",
               "Samoa vreme",
               "",
            };
        final String[] Davis = new String[] {
               "Dejvis vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba, standardno vreme",
               "",
               "Kuba, letnje vreme",
               "",
               "Kuba",
               "",
            };
        final String[] GMT = new String[] {
               "Srednje vreme po Grini\u010du",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipini, standardno vreme",
               "",
               "Filipini, letnje vreme",
               "",
               "Filipini vreme",
               "",
            };
        final String[] French_Southern = new String[] {
               "Francusko ju\u017eno i antarkti\u010dko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nova Kaledonija, standardno vreme",
               "",
               "Nova Kaledonija, letnje vreme",
               "",
               "Nova Kaledonija vreme",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunej Darusalum vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Iran, standardno vreme",
               "",
               "Iran, letnje vreme",
               "",
               "Iran vreme",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikistan vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga, standardno vreme",
               "",
               "Tonga, letnje vreme",
               "",
               "Tonga vreme",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161, standardno vreme",
               "",
               "Banglade\u0161, letnje vreme",
               "",
               "Banglade\u0161 vreme",
               "",
            };
        final String[] Peru = new String[] {
               "Peru, standardno vreme",
               "",
               "Peru, letnje vreme",
               "",
               "Peru vreme",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Isto\u010dni Grenland, standardno vreme",
               "",
               "Isto\u010dni Grenland, letnje vreme",
               "",
               "Isto\u010dni Grenland",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Isto\u010dno-indonezijsko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistan vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Kolumbija, standardno vreme",
               "",
               "Kolumbija, letnje vreme",
               "",
               "Kolumbija vreme",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Francuska Gvajana vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Australijsko isto\u010dno standardno vreme",
               "",
               "Australijsko isto\u010dno letnje vreme",
               "",
               "Australijsko isto\u010dno vreme",
               "",
            };
        final String[] Chile = new String[] {
               "\u010cile, standardno vreme",
               "",
               "\u010cile, letnje vreme",
               "",
               "\u010cile vreme",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkuck, standardno vreme",
               "",
               "Irkuck, letnje vreme",
               "",
               "Irkuck vreme",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruzija, standardno vreme",
               "",
               "Gruzija, letnje vreme",
               "",
               "Gruzija vreme",
               "",
            };
        final String[] Choibalsan = new String[] {
               "\u010cojbalsan, standardno vreme",
               "",
               "\u010cojbalsan, letnje vreme",
               "",
               "\u010cojbalsan vreme",
               "",
            };
        final String[] China = new String[] {
               "Kinesko standardno vreme",
               "",
               "Kina, letnje vreme",
               "",
               "Kina vreme",
               "",
            };
        final String[] Armenia = new String[] {
               "Jermenija, standardno vreme",
               "",
               "Jermenija, letnje vreme",
               "",
               "Jermenija vreme",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Centralno-afri\u010dko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Japansko standardno vreme",
               "",
               "Japansko letnje vreme",
               "",
               "Japansko vreme",
               "",
            };
        final String[] Taipei = new String[] {
               "Tajpej, standardno vreme",
               "",
               "Tajpej, letnje vreme",
               "",
               "Tajpej vreme",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd, standardno vreme",
               "",
               "Hovd, letnje vreme",
               "",
               "Hovd vreme",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australijsko centralno zapadno standardno vreme",
               "",
               "Australijsko centralno zapadno letnje vreme",
               "",
               "Australijsko centralno zapadno vreme",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahalin, standardno vreme",
               "",
               "Sahalin, letnje vreme",
               "",
               "Sahalin vreme",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paragvaj, standardno vreme",
               "",
               "Paragvaj, letnje vreme",
               "",
               "Paragvaj vreme",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malezija vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauricijus, standardno vreme",
               "",
               "Mauricijus, letnje vreme",
               "",
               "Mauricijus vreme",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Isto\u010dno-afri\u010dko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomonska Ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Mar\u0161alska Ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Njufaundlend, standardno vreme",
               "",
               "Njufaundlend, letnje vreme",
               "",
               "Njufaundlend",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Avganistan vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong, standardno vreme",
               "",
               "Hong Kong, letnje vreme",
               "",
               "Hong Kong vreme",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantsko standardno vreme",
               "",
               "Atlantsko letnje vreme",
               "",
               "Atlantsko vreme",
               "",
            };
        final String[] Israel = new String[] {
               "Izraelsko standardno vreme",
               "",
               "Izraelsko letnje vreme",
               "",
               "Izraelsko vreme",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Centralno-indonezijsko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk, standardno vreme",
               "",
               "Omsk, letnje vreme",
               "",
               "Omsk vreme",
               "",
            };
        final String[] Seychelles = new String[] {
               "Sej\u0161eli vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugvaj, standardno vreme",
               "",
               "Urugvaj, letnje vreme",
               "",
               "Urugvaj vreme",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "\u010cuuk vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu, standardno vreme",
               "",
               "Vanuatu, letnje vreme",
               "",
               "Vanuatu vreme",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk, standardno vreme",
               "",
               "Novosibirsk, letnje vreme",
               "",
               "Novosibirsk vreme",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapur, standardno vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Azori, standardno vreme",
               "",
               "Azori, letnje vreme",
               "",
               "Azori vreme",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinam vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk, standardno vreme",
               "",
               "Krasnojarsk, letnje vreme",
               "",
               "Krasnojarsk vreme",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mijanmar vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazon, standardno vreme",
               "",
               "Amazon, letnje vreme",
               "",
               "Amazon vreme",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Isto\u010dno-kazahstansko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ei, standardno vreme",
               "",
               "Fid\u017ei, letnje vreme",
               "",
               "Fid\u017ei vreme",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsko-kam\u010datsko standardno vreme",
               "",
               "Petropavlovsko-kam\u010datsko letnje ra\u010dunanje vremena",
               "",
               "Petropavlovsko-kam\u010datsko vreme",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Ostrvo Makveri vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajsko-aleutsko standardno vreme",
               "",
               "Havajsko-aleutsko letnje vreme",
               "",
               "Havajsko-aleutsko vreme",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Australijsko centralno standardno vreme",
               "",
               "Australijsko centralno letnje vreme",
               "",
               "Australijsko centralno vreme",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Severnoameri\u010dko pacifi\u010dko standardno vreme",
               "",
               "Severnoameri\u010dko pacifi\u010dko letnje vreme",
               "",
               "Severnoameri\u010dko pacifi\u010dko vreme",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan, standardno vreme",
               "",
               "Turkmenistan, letnje vreme",
               "",
               "Turkmenistan vreme",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Zapadnoevropsko standardno vreme",
               "WET",
               "Zapadnoevropsko letnje vreme",
               "WEST",
               "Zapadnoevropsko vreme",
               "WET",
            };
        final String[] Guyana = new String[] {
               "Gvajana vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitkern vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotera vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbejd\u017ean, standardno vreme",
               "",
               "Azerbejd\u017ean, letnje vreme",
               "",
               "Azerbejd\u017ean vreme",
               "",
            };
        final String[] Mawson = new String[] {
               "Moson vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksi\u010dki Pacifik, standardno vreme",
               "",
               "Meksi\u010dki Pacifik, letnje vreme",
               "",
               "Meksi\u010dki Pacifik",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Zapadno-afri\u010dko standardno vreme",
               "",
               "Zapadno-afri\u010dko letnje vreme",
               "",
               "Zapadno-afri\u010dko vreme",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ju\u017ena D\u017eord\u017eija vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Severozapadni Meksiko, standardno vreme",
               "",
               "Severozapadni Meksiko, letnje vreme",
               "",
               "Severozapadni Meksiko",
               "",
            };
        final String[] Easter = new String[] {
               "Uskr\u0161nja ostrva, standardno vreme",
               "",
               "Uskr\u0161nja ostrva, letnje vreme",
               "",
               "Uskr\u0161nja ostrva vreme",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dimon d\u2019Urvil vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Zapadni Grenland, standardno vreme",
               "",
               "Zapadni Grenland, letnje vreme",
               "",
               "Zapadni Grenland",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvador vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Zalivsko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Korejsko standardno vreme",
               "",
               "Korejsko letnje vreme",
               "",
               "Korejsko vreme",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Australijsko zapadno standardno vreme",
               "",
               "Australijsko zapadno letnje vreme",
               "",
               "Australijsko zapadno vreme",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Zapadno-indonezijsko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Severnoameri\u010dko planinsko standardno vreme",
               "",
               "Severnoameri\u010dko planinsko letnje vreme",
               "",
               "Severnoameri\u010dko planinsko vreme",
               "",
            };
        final String[] Marquesas = new String[] {
               "Markiz vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabijsko standardno vreme",
               "",
               "Arabijsko letnje vreme",
               "",
               "Arabijsko vreme",
               "",
            };
        final String[] Alaska = new String[] {
               "Aljaska, standardno vreme",
               "",
               "Aljaska, letnje vreme",
               "",
               "Aljaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok, standardno vreme",
               "",
               "Vladivostok, letnje vreme",
               "",
               "Vladivostok vreme",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u010camoro vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Nova Gvineja vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronja, standardno vreme",
               "",
               "Fernando de Noronja, letnje vreme",
               "",
               "Fernando de Noronja vreme",
               "",
            };
        final String[] Brasilia = new String[] {
               "Brazilija, standardno vreme",
               "",
               "Brazilija, letnje vreme",
               "",
               "Brazilija vreme",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadir standardno vreme",
               "",
               "Anadir letnje ra\u010dunanje vremena",
               "",
               "Anadir vreme",
               "",
            };
        final String[] Samara = new String[] {
               "Samara standardno vreme",
               "",
               "Samara letnje ra\u010dunanje vremena",
               "",
               "Samara vreme",
               "",
            };
        final String[] Pyongyang = new String[] {
               "Pjongjan\u0161ko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indijsko standardno vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Kukova ostrva, standardno vreme",
               "",
               "Kukova ostrva, polu-letnje vreme",
               "",
               "Kukova ostrva vreme",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Finiks" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.America/Antigua", "Antigva" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Markiz" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Ajres" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshagen" },
            { "timezone.excity.America/Anchorage", "Enkorid\u017e" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Srednje vreme po Grini\u010du",
                    "GMT",
                    "Britanija, letnje vreme",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Bijula, Severna Dakota" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Librevil" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kin\u0161asa" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Talin" },
            { "timezone.excity.Pacific/Truk", "Truk" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Izabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "London" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitkern" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nom" },
            { "Pacific/Tahiti", Tahiti },
            { "HST", Hawaii_Aleutian },
            { "timezone.excity.America/Vancouver", "Vankuver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "\u010cojbalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Sv. Lucija" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznjeck" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midvej" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Godthab", "Gothab" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Pert" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Africa/Asmera", "Asmera" },
            { "timezone.excity.Arctic/Longyearbyen", "Longjerbjen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.Africa/Windhoek", "Vindhuk" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.America/Lower_Princes", "Louer Prinsiz Kvorter" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Ban\u017eul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Mikelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "\u017du\u017eui" },
            { "timezone.excity.America/Argentina/Ushuaia", "U\u0161uaija" },
            { "timezone.excity.America/North_Dakota/Center", "Centar, Severna Dakota" },
            { "timezone.excity.America/Cayenne", "Kajen" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "D\u017eonston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "D\u017eersi" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "Ju\u017ena D\u017eord\u017eija" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "D\u017euba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnom Pen" },
            { "timezone.excity.Europe/Rome", "Rim" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Moson" },
            { "timezone.excity.Asia/Karachi", "Kara\u010di" },
            { "timezone.excity.America/Resolute", "Resolut" },
            { "timezone.excity.Africa/Nouakchott", "Nuak\u0161ot" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Ajun" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Novi Salem, Severna Dakota" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ohinaga" },
            { "timezone.excity.Europe/Zurich", "Cirih" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "Sao Paolo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "Njujork" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Etc/Unknown", "Nepoznat grad" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Tul" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "timezone.excity.America/Indiana/Petersburg", "Pitersburg, Indijana" },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Vinipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Mekvori" },
            { "timezone.excity.Europe/Uzhgorod", "U\u017egorod" },
            { "timezone.excity.America/Caracas", "Karakas" },
            { "timezone.excity.America/Dawson_Creek", "Doson Krik" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blank-Sejblon" },
            { "timezone.excity.Africa/Algiers", "Al\u017eir" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Kartum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galapagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuman" },
            { "timezone.excity.America/Rio_Branco", "Rio Branko" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Africa/Niamey", "Nijamej" },
            { "timezone.excity.Indian/Mayotte", "Majot" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Srednje vreme po Grini\u010du",
                    "GMT",
                    "Irska, standardno vreme",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.Asia/Jakarta", "D\u017eakarta" },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efat" },
            { "timezone.excity.Asia/Aqtobe", "Akutobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Sveta Jelena" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "timezone.excity.Europe/Isle_of_Man", "Ostrvo Man" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Kiraso" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Gvajana" },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Pariz" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "timezone.excity.America/Scoresbysund", "Skorezbisund" },
            { "timezone.excity.America/Indiana/Vevay", "Vevaj, Indijana" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Svift Kurent" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budimpe\u0161ta" },
            { "timezone.excity.America/Catamarca", "Katamarka" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spejn" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.America/Santarem", "Santarem" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Jakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Urumqi", "Urum\u0107i" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bisao" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161" },
            { "timezone.excity.America/Bahia_Banderas", "Baija Banderas" },
            { "timezone.excity.Asia/Jayapura", "D\u017eajapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Gvadalkanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.America/Nassau", "Nasau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Tajpej" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Srednje vreme po Grini\u010du",
                    "GMT",
                    "Britanija, letnje vreme",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigo" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "timezone.excity.America/Kentucky/Monticello", "Monti\u010delo, Kentaki" },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumba\u0161i" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Antarctica/McMurdo", "Makmurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednjekolimsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Najrobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "timezone.excity.America/Indiana/Marengo", "Marengo, Indijana" },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johanesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dablin" },
            { "timezone.excity.Antarctica/Casey", "Kejsi" },
            { "timezone.excity.Atlantic/Cape_Verde", "Zelenortska Ostrva" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Gus Bej" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "timezone.excity.America/Los_Angeles", "Los An\u0111eles" },
            { "MST", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Kuiaba" },
            { "Pacific/Noumea", New_Caledonia },
            { "timezone.excity.Atlantic/Azores", "Azori" },
            { "timezone.excity.Australia/Melbourne", "Melburn" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Angvila" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brizbejn" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vijentijan" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Bo\u017ei\u0107" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Tander Bej" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Luivile" },
            { "timezone.excity.America/Cancun", "Kankun" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hil" },
            { "timezone.excity.Europe/Kaliningrad", "Kalinjingrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Pacific/Tarawa", "Tarava" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunsion" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "Koordinisano univerzalno vreme",
                    "UTC",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161injev" },
            { "timezone.excity.America/Moncton", "Monkton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnjus" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "\u010cikago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Pacific/Ponape", "Ponape" },
            { "timezone.excity.Asia/Irkutsk", "Irkuck" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skoplje" },
            { "timezone.excity.America/Chihuahua", "\u010cihuahua" },
            { "America/Belize", America_Central },
            { "timezone.excity.America/Indiana/Winamac", "Vinamak, Indijana" },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Rejkjavik" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Resife" },
            { "timezone.excity.Pacific/Wallis", "Valis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Huan" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Shanghai", "\u0160angaj" },
            { "timezone.excity.America/Juneau", "\u017duno" },
            { "timezone.excity.Pacific/Bougainville", "Buganvil" },
            { "timezone.excity.Pacific/Apia", "Apija" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Uskr\u0161nje ostrvo" },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menomini" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Hau" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Vejk" },
            { "timezone.excity.Atlantic/Canary", "Kanarska ostrva" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glejs Bej" },
            { "timezone.excity.Africa/Casablanca", "Kazablanka" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendajk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Kreston" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "timezone.excity.America/Indiana/Tell_City", "Tel Siti, Indijana" },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tome" },
            { "timezone.excity.America/Dawson", "Doson" },
            { "timezone.excity.Africa/Abidjan", "Abid\u017ean" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Gvadalupe" },
            { "timezone.excity.Africa/Freetown", "Fritaun" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovija" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rejni River" },
            { "timezone.excity.America/Coral_Harbour", "Koral Harbur" },
            { "timezone.excity.Asia/Beirut", "Bejrut" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontijanak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dimon d\u2019Urvil" },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Masejo" },
            { "timezone.excity.America/Guayaquil", "Gvajakil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "Sent Vinsent" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopolj" },
            { "timezone.excity.Indian/Kerguelen", "Kergelen" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderberi" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjang" },
            { "timezone.excity.Europe/Bucharest", "Bukure\u0161t" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Atina" },
            { "Africa/Djibouti", Africa_Eastern },
            { "EST", America_Eastern },
            { "timezone.excity.America/Indiana/Knox", "Noks, Indijana" },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Veljo" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managva" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Australia/Darwin", "Darvin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jerusalim" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Rijad" },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Ko\u0161re" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazavil" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Galjegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Baija" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.America/St_Kitts", "Sent Kits" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar-es-Salam" },
            { "timezone.excity.America/Monterrey", "Monterej" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Belem" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho \u0160i Min" },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Europe/Sofia", "Sofija" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrakan" },
            { "timezone.excity.America/Yellowknife", "Jelounajf" },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.America/Puerto_Rico", "Porto Riko" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Kalkuta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Trol" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.America/Port-au-Prince", "Port o Prens" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Iukla" },
            { "timezone.excity.America/Mexico_City", "Meksiko Siti" },
            { "timezone.excity.Pacific/Kwajalein", "Kvad\u017ealejin" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisabon" },
            { "timezone.excity.Pacific/Gambier", "Gambije" },
            { "timezone.excity.America/Boise", "Bojzi" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporo\u017eje" },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "\u010catam" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Morzbi" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendosa" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronja" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Gernzi" },
            { "timezone.excity.America/Argentina/San_Luis", "San Lui" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Aragvajana" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "Kordoba" },
            { "timezone.excity.America/Cambridge_Bay", "Kembrid\u017e Bej" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Kampo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantir" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sidnej" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Dejvis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Mauricijus" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioha" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Marihamn" },
            { "timezone.excity.America/St_Johns", "Sv. D\u017eon" },
            { "timezone.excity.America/St_Barthelemy", "Sv. Bartolomej" },
            { "timezone.excity.America/Santiago", "Santjago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "Sv. Toma" },
            { "timezone.excity.Europe/Busingen", "Bisingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Nd\u017eamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelejd" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Be\u010d" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Kajmanska Ostrva" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nikozija" },
            { "timezone.excity.Europe/Kiev", "Kijev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bud\u017eumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.Asia/Brunei", "Brunej" },
            { "timezone.excity.Atlantic/Faeroe", "Farska Ostrva" },
            { "timezone.excity.America/Whitehorse", "Vajthors" },
            { "timezone.excity.Asia/Kuching", "Ku\u010ding" },
            { "timezone.excity.America/Halifax", "Halifaks" },
            { "timezone.excity.America/Merida", "Merida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Okland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "A\u0161habad" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "\u0160ova" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.America/Hermosillo", "Hermosiljo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "Reunion" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stenli" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Thimphu", "Timpu" },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Uagadugu" },
            { "timezone.excity.Africa/Gaborone", "Gaboron" },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "\u010cagos" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.America/Iqaluit", "Ikvaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "timezone.excity.Pacific/Saipan", "Sajpan" },
            { "timezone.excity.Indian/Cocos", "Kokos" },
            { "timezone.excity.Australia/Currie", "Kari" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Aman" },
            { "timezone.excity.America/Indiana/Vincennes", "Vincenes, Indijana" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Brisel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Komoro" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stokholm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tihuana" },
            { "timezone.excity.Indian/Maldives", "Maldivi" },
        };
        return data;
    }
}
